/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.SimulationEvent;
import apiipc.generated.events.SimulationEventListener;
import apiipc.generated.sim.Simulation;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationEventRegistry
extends IPCEventRegistry {
    protected Set<SimulationEventListener> globalListeners = new HashSet<SimulationEventListener>();
    protected Map<String, Set<SimulationEventListener>> specificObjectListeners = new HashMap<String, Set<SimulationEventListener>>();

    public SimulationEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "Simulation";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        SimulationEvent simulationEvent = null;
        if (string.equalsIgnoreCase("forwardStarted")) {
            simulationEvent = new SimulationEvent.ForwardStarted(iPCEventLTV);
        } else if (string.equalsIgnoreCase("forwardEnded")) {
            simulationEvent = new SimulationEvent.ForwardEnded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("newFrameInstanceAdded")) {
            simulationEvent = new SimulationEvent.NewFrameInstanceAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("simulationReset")) {
            simulationEvent = new SimulationEvent.SimulationReset(iPCEventLTV);
        } else if (string.equalsIgnoreCase("simulationModeChanged")) {
            simulationEvent = new SimulationEvent.SimulationModeChanged(iPCEventLTV);
        } else {
            return;
        }
        for (SimulationEventListener object : this.globalListeners) {
            object.handleEvent(simulationEvent);
        }
        Set<SimulationEventListener> set = this.specificObjectListeners.get(simulationEvent.objectUUID.toString());
        if (set != null) {
            for (SimulationEventListener simulationEventListener : set) {
                simulationEventListener.handleEvent(simulationEvent);
            }
        }
    }

    public void addListenerFiltered(SimulationEventListener simulationEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("forwardStarted");
                this.register("forwardEnded");
                this.register("newFrameInstanceAdded");
                this.register("simulationReset");
                this.register("simulationModeChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(simulationEventListener);
    }

    public void addSpecificListenerFiltered(SimulationEventListener simulationEventListener, Simulation simulation, List<String> list) throws IOException {
        UUID uUID = simulation.getObjectUUID();
        String string = uUID.toString();
        Set<SimulationEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<SimulationEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "forwardStarted");
                this.register(uUID, "forwardEnded");
                this.register(uUID, "newFrameInstanceAdded");
                this.register(uUID, "simulationReset");
                this.register(uUID, "simulationModeChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(simulationEventListener);
    }

    public void removeListenerFiltered(SimulationEventListener simulationEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("forwardStarted");
                this.deregister("forwardEnded");
                this.deregister("newFrameInstanceAdded");
                this.deregister("simulationReset");
                this.deregister("simulationModeChanged");
            }
            this.globalListeners.remove(simulationEventListener);
        }
    }

    public void removeSpecificListenerFiltered(SimulationEventListener simulationEventListener, Simulation simulation, List<String> list) throws IOException {
        UUID uUID = simulation.getObjectUUID();
        String string = uUID.toString();
        Set<SimulationEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "forwardStarted");
            this.deregister(uUID, "forwardEnded");
            this.deregister(uUID, "newFrameInstanceAdded");
            this.deregister(uUID, "simulationReset");
            this.deregister(uUID, "simulationModeChanged");
            set.remove(simulationEventListener);
        }
    }

    public void addListener(SimulationEventListener simulationEventListener) throws IOException {
        this.addListenerFiltered(simulationEventListener, null);
    }

    public void addListener(SimulationEventListener simulationEventListener, Simulation simulation) throws IOException {
        this.addSpecificListenerFiltered(simulationEventListener, simulation, null);
    }

    public void removeListener(SimulationEventListener simulationEventListener) throws IOException {
        this.removeListenerFiltered(simulationEventListener, null);
    }

    public void removeListener(SimulationEventListener simulationEventListener, Simulation simulation) throws IOException {
        this.removeSpecificListenerFiltered(simulationEventListener, simulation, null);
    }
}

